<?php

namespace Modules\Ebay\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Ebay\Entities\EbayLegacyProduct;

/**
 *
 * @mixin EbayLegacyProduct|array
 */
class SalesOrderLineListingEbayResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this['id'],
            'product_id' => @$this['product_id'] ?? null,
            'unique_sales_channel_product_id' => $this['legacyItemId'],
            'skuAlias' => $this['sku'],
            'sku' => $this['sku'],
            'title' => $this['title'],
            'quantity' => $this['quantity'],
            'amount' => $this['totalValue'],
            'tax_allocation' => collect($this['json_object']['taxes'])->sum('amount'),
        ];
    }
}
