<?php

namespace Modules\Ebay\Http\Controllers;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelIntegrationInstanceController;
use App\DataTable\DataTable;
use App\Repositories\SalesChannelRepository;
use App\Response;
use Modules\Ebay\Data\StoreEbayIntegrationData;
use Modules\Ebay\Data\UpdateEbayIntegrationData;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Http\Resources\EbayIntegrationInstanceResource;
use Modules\Ebay\Repositories\EbayIntegrationInstanceRepository;
use Modules\Ebay\Services\EbayClient;
use Throwable;

class EbayIntegrationInstanceController extends AbstractSalesChannelIntegrationInstanceController
{
    use DataTable;

    protected EbayIntegrationInstanceRepository $integrationInstanceRepository;

    protected SalesChannelRepository $salesChannelRepository;

    public function __construct()
    {
        $this->integrationInstanceRepository = app(EbayIntegrationInstanceRepository::class);
        $this->salesChannelRepository        = app(SalesChannelRepository::class);
        parent::__construct();
    }

    protected function getModel(): string
    {
        return EbayIntegrationInstance::class;
    }

    protected function getResource(): string
    {
        return EbayIntegrationInstanceResource::class;
    }

    /**
     * @throws Throwable
     */
    public function store(StoreEbayIntegrationData $data)
    {
        $response = parent::abstractStore($data);

        $integrationInstance = $response->getOriginalData();

        return $response->setStatus(201)->addAdditional(
            'redirect_url',
            (new EbayClient($integrationInstance))->getRedirectUrl()
        );
    }

    public function update(UpdateEbayIntegrationData $data, EbayIntegrationInstance $integrationInstance): Response
    {
        return parent::abstractUpdate($data, $integrationInstance)->response;
    }

    public function show(EbayIntegrationInstance $integrationInstance): Response
    {
        return $this->abstractShow($integrationInstance);
    }

    /**
     * @throws Throwable
     */
    public function destroy(EbayIntegrationInstance $integrationInstance): ?Response
    {
        return $this->abstractDestroy($integrationInstance);
    }
}
