<?php

namespace Modules\Ebay\Entities;

use App\Abstractions\UniqueFieldsInterface;
use App\Models\Product;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Ebay\Database\Factories\EbayProductSettingFactory;

/**
 * @property int $id
 * @property int $integration_instance_id
 * @property int $product_id
 * @property boolean $auction_until_sold_enabled
 * @property float $auction_until_sold_price_reduction_percentage
 * @property float $auction_until_sold_minimum_price
 * @property EbayIntegrationInstance $integrationInstance
 * @property Product $product
 * @property Carbon $created_at
 * @property Carbon $updated_at
 *
 */
class EbayProductSetting extends Model implements UniqueFieldsInterface
{
    use HasFactory;

    protected $guarded = [];

    /*
    |--------------------------------------------------------------------------
    | Implementers
    |--------------------------------------------------------------------------
    */
    public static function getUniqueFields(): array
    {
        return ['integration_instance_id', 'product_id'];
    }

    public static function newFactory()
    {
        return EbayProductSettingFactory::new();
    }

    /*
    |--------------------------------------------------------------------------
    | Relations
    |--------------------------------------------------------------------------
    */

    public function integrationInstance(): BelongsTo
    {
        return $this->belongsTo(EbayIntegrationInstance::class);
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
