<?php

namespace Modules\Ebay\Entities;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelIntegrationInstance;
use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelProductManager;
use App\Helpers;
use App\Models\DataImportMapping;
use App\Models\Integration;
use Carbon\CarbonImmutable;
use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\DB;
use Modules\Ebay\Database\Factories\EbayIntegrationInstanceFactory;
use Modules\Ebay\Managers\EbayProductManager;

/**
 * @property-read DataImportMapping $dataImportMapping
 */
class EbayIntegrationInstance extends AbstractSalesChannelIntegrationInstance
{
    protected $table = 'integration_instances';

    protected $primaryKey = 'id';

    public static function getOrderClass(): string
    {
        return EbayOrder::class;
    }

    public static function getOrderLineClass(): string
    {
        return EbayOrderItem::class;
    }

    public static function getProductClass(): string
    {
        return EbayLegacyProduct::class;
    }

    /**
     * @throws Exception
     */
    public function getProductManager(): AbstractSalesChannelProductManager
    {
        return new EbayProductManager($this);
    }

    protected static function booted()
    {
        static::addGlobalScope('ebay', function (Builder $query) {
            return $query->whereHas('integration', function (Builder $query) {
                $query->where('name', Integration::NAME_EBAY);
            });
        });
    }

    public static function newFactory(): Factory
    {
        return new EbayIntegrationInstanceFactory();
    }

    public function isUsingLegacyApi(): bool
    {
        return (@$this->integration_settings['use_legacy_services'] === true) ?? true;
    }

    /*
    |--------------------------------------------------------------------------
    | Other
    |--------------------------------------------------------------------------
    */

    public function delete()
    {
        DB::transaction(function () {
            if ($this->salesChannel()->first() !== null) {
                $this->salesChannel()->first()->productListings()->delete();
            }

            /*
             * Clear all related records
             *
             * Many other models get deleted but handled through corresponding models
             */
            $this->apiLogs()->delete();
            $this->dataImportMapping()->delete();
            $this->orders()->delete();
            $this->products()->delete();
            $this->salesChannel()->delete();

            return parent::delete();
        });
    }
}
