<?php

namespace Modules\Ebay\Entities;

use App\Models\Integration;
use Illuminate\Database\Eloquent\Builder;

class EbayIntegration extends Integration
{
    protected $table = 'integrations';

    protected $primaryKey = 'id';

    protected static function booted(): void
    {
        static::addGlobalScope('ebay', function (Builder $query) {
            $query->where('name', Integration::NAME_EBAY);
        });
    }
}
