<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Deleting duplicates: keep only the latest record for each ebay_order_id and lineItemId combination
        DB::statement("
            DELETE e1 FROM ebay_order_items e1
            JOIN (
                SELECT MAX(id) as id, ebay_order_id, lineItemId
                FROM ebay_order_items
                GROUP BY ebay_order_id, lineItemId
                HAVING COUNT(*) > 1
            ) e2 ON e1.ebay_order_id = e2.ebay_order_id AND e1.lineItemId = e2.lineItemId AND e1.id < e2.id
        ");

        // Adding a unique composite index
        Schema::table('ebay_order_items', function (Blueprint $table) {
            $table->unique(['ebay_order_id', 'lineItemId'], 'ebay_order_line_item_unique');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Drop the unique index
        Schema::table('ebay_order_items', function (Blueprint $table) {
            $table->dropUnique('ebay_order_line_item_unique');
        });
    }
};
