<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('woo_commerce_order_items', function (Blueprint $table) {
            // Drop the existing foreign key
            $table->dropForeign('woo_commerce_order_items_woo_commerce_order_id_foreign');

            // Add it back with onDelete('cascade')
            $table->foreign('woo_commerce_order_id')
                ->references('id')
                ->on('woo_commerce_orders')
                ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('woo_commerce_order_items', function (Blueprint $table) {
            // Drop the foreign key with cascade delete
            $table->dropForeign('woo_commerce_order_items_woo_commerce_order_id_foreign');

            // Add it back with the original constraint
            $table->foreign('woo_commerce_order_id')
                ->references('id')
                ->on('woo_commerce_orders');
        });
    }
};
