<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ebay_order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ebay_order_id')->index()->constrained();
            $table->string('lineItemId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.lineItemId'))")->index();
            $table->string('legacyItemId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.legacyItemId'))")->index();
            $table->string('sku')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.sku'))");
            $table->string('title')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.title'))");
            $table->decimal('lineItemCostValue', 9, 2)->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.lineItemCost.value'))");
            $table->string('lineItemCostCurrency')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.lineItemCost.currency'))");
            $table->integer('quantity')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.quantity'))");
            $table->string('soldFormat')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.soldFormat'))");
            $table->string('listingMarketplaceId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.listingMarketplaceId'))");
            $table->string('purchaseMarketplaceId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.purchaseMarketplaceId'))");
            $table->string('lineItemFulfillmentStatus')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.lineItemFulfillmentStatus'))");
            $table->decimal('totalValue', 9, 2)->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.total.value'))");
            $table->string('totalCurrency')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.total.currency'))");
            $table->decimal('shippingCostValue', 9, 2)->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.deliveryCost.shippingCost.value'))");
            $table->string('shippingCostCurrency')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.deliveryCost.shippingCost.currency'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ebay_order_items');
    }
};
