<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('ebay_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index()->constrained();
            $table->string('orderId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.orderId'))")->index();
            $table->dateTime('creationDateUtc')->storedAs("STR_TO_DATE(JSON_UNQUOTE(json_extract(json_object,'$."."creationDateUtc')),'%Y-%m-%d %H:%i:%s')");
            $table->dateTime('lastModifiedDateUtc')->storedAs("STR_TO_DATE(JSON_UNQUOTE(json_extract(json_object,'$."."lastModifiedDateUtc')),'%Y-%m-%d %H:%i:%s')");
            $table->string('orderPaymentStatus')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.orderPaymentStatus'))");
            $table->string('orderFulfillmentStatus')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.orderFulfillmentStatus'))");
            $table->decimal('totalValue', 9, 2)->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.pricingSummary.total.value'))");
            $table->string('totalCurrency')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.pricingSummary.total.currency'))");
            $table->string('salesRecordReference')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.salesRecordReference'))");
            $table->decimal('totalMarketplaceFeeValue', 9, 2)->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.totalMarketplaceFee.value'))");
            $table->string('totalMarketplaceFeeCurrency')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.totalMarketplaceFee.currency'))");
            $table->string('error_log')->nullable()->after('totalMarketplaceFeeCurrency');
            $table->json('json_object');
            $table->dateTime('archived_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ebay_orders');
    }
};
