<?php

namespace Modules\Ebay\Database\Factories;

use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Entities\EbayProductSetting;

class EbayProductSettingFactory extends Factory
{
    protected $model = EbayProductSetting::class;

    public function definition(): array
    {
        return [
            'integration_instance_id' => EbayIntegrationInstance::factory(),
            'product_id' => Product::factory(),
            'auction_until_sold_enabled' => $this->faker->boolean(),
            'auction_until_sold_price_reduction_percentage' => $this->faker->randomFloat(),
            'auction_until_sold_minimum_price' => $this->faker->randomFloat(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
