<?php

namespace Modules\Ebay\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Entities\EbayOrder;

/**
 * @extends Factory<EbayOrder>
 */
class EbayOrderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = EbayOrder::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var EbayIntegrationInstance $ebayIntegrationInstance */
        $ebayIntegrationInstance = EbayIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $ebayIntegrationInstance->id,
            'json_object' => [
                'orderId' => $this->faker->unique()->numberBetween(1, 2000),
            ],
        ];
    }
}
