<?php

namespace Modules\Ebay\Database\Factories;

use App\Models\Integration;
use App\Models\Supplier;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Ebay\Entities\EbayIntegrationInstance;

class EbayIntegrationInstanceFactory extends Factory
{
    protected $model = EbayIntegrationInstance::class;

    public function definition(): array
    {
        /** @var Integration $integration */
        $integration = Integration::query()->where('name', Integration::NAME_EBAY)->first();

        return [
            'integration_id' => $integration->id,
            'name' => $this->faker->sentence(3),
            'connection_settings' => [
                'refresh_token' => $this->faker->word(),
            ],
            'integration_settings' => [
                'start_date' => now()->subYears(2)->toDateTimeString(),
            ],
        ];
    }
}
