<?php

namespace Modules\Ebay\Data;

use App\Abstractions\Integrations\Data\SalesChannelIntegrationSettingsData;
use App\Abstractions\Integrations\Data\StoreSalesChannelIntegrationDataInterface;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\Unique;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class StoreEbayIntegrationData extends Data implements StoreSalesChannelIntegrationDataInterface
{
    public function __construct(
        #[Unique('integration_instances', 'name')]
        public string $name,
        #[Exists('integrations', 'id')]
        public int $integration_id,
        public EbayConnectionSettingsData|Optional $connection_settings,
        public SalesChannelIntegrationSettingsData $integration_settings,
        public bool $is_automatic_sync_enabled = false,
    )
    {
    }
}