<?php

declare(strict_types=1);

namespace Modules\Ebay\Data;

use App\Abstractions\Integrations\Data\AbstractSalesChannelOrderData;
use Carbon\Carbon;

class EbayOrderData extends AbstractSalesChannelOrderData
{
    public function __construct(
        public array $json_object
    ) {
        $this->json_object['creationDateUtc'] = $this->json_object['creationDate'] ? Carbon::parse($this->json_object['creationDate'])->toDateTimeString() : null;
        $this->json_object['lastModifiedDateUtc'] = $this->json_object['lastModifiedDate'] ? Carbon::parse($this->json_object['lastModifiedDate'])->toDateTimeString() : null;
        parent::__construct($this->json_object);
    }
}
