<?php

declare(strict_types=1);

namespace Modules\Ebay\Data;

use App\Abstractions\Integrations\Data\AbstractSalesChannelOrderData;
use Carbon\Carbon;

class EbayLegacyProductData extends AbstractSalesChannelOrderData
{
    public function __construct(
        public array $json_object,
    ) {
        $this->json_object['StartTimeUtc'] = Carbon::parse($this->json_object['ListingDetails']['StartTime'])->toDateTimeString();
        if (isset($this->json_object['ListingDetails']['EndTime'])) {
            $this->json_object['EndTimeUtc'] = Carbon::parse($this->json_object['ListingDetails']['EndTime'])->toDateTimeString();
        }
        parent::__construct($this->json_object);
    }
}
