<?php

namespace Modules\Ebay\Console;

use Illuminate\Console\Command;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Jobs\RefreshEbayProductsJob;

class RefreshEbayProductsCommand extends Command
{
    public function __construct(private readonly EbayIntegrationInstance $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ebay:products:refresh {--integrationInstanceId=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh Ebay Products';

    public function handle(): int
    {
        // TODO: Read ebay documentation to figure out how to get all listings (it probably isn't this call)
        // https://developer.ebay.com/support/kb-article?KBid=477
        $integrationInstanceId = $this->option('integrationInstanceId');
        if ($integrationInstanceId) {
            $query = $this->integrationInstanceRepository->where('id', (int) $integrationInstanceId);
        } else {
            $query = $this->integrationInstanceRepository->all();
        }

        $this->info('Refreshing Ebay Products for '.$query->count().' integrationInstances');

        $query
            ->each(function (EbayIntegrationInstance $ebayIntegrationInstance) {
                RefreshEbayProductsJob::dispatch(
                    $ebayIntegrationInstance,
                );
            });

        return 0;
    }
}
