<?php

declare(strict_types=1);

namespace Modules\Ebay\Console;

use Illuminate\Console\Command;
use Modules\Ebay\Entities\EbayIntegrationInstance;
use Modules\Ebay\Jobs\CreateSkuOrdersFromEbayOrdersJob;

class CreateSkuOrdersFromEbayOrdersCommand extends Command
{
    protected $signature = 'ebay:orders:create-sku-orders {--integrationInstanceId=}';

    protected $description = 'Create SKU orders from eBay orders.';

    public function __construct(private readonly EbayIntegrationInstance $integrationInstanceRepository)
    {
        parent::__construct();
    }

    public function handle(): int
    {
        if ($this->option('integrationInstanceId')) {
            $query = $this->integrationInstanceRepository->all($this->option('integrationInstanceId'));
        } else {
            $query = $this->integrationInstanceRepository->all();
        }

        $this->info('Creating SKU orders from Ebay orders for '.$query->count().' integrationInstances');

        $query
            ->each(function (EbayIntegrationInstance $ebayIntegrationInstance) {
                dispatch_sync(
                    new CreateSkuOrdersFromEbayOrdersJob($ebayIntegrationInstance)
                );
            });

        return self::SUCCESS;
    }
}
