<?php

namespace Modules\Ebay\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Carbon\Carbon;
use Modules\Ebay\ApiDataTransferObjects\Concerns\EbayDatesTrait;

class EbayLegacyGetOrdersAdt implements ApiDataTransformerInterface
{
    use EbayDatesTrait;

    const DATES_TO_SANITIZE = [
        'last_updated_after',
        'last_updated_before',
    ];

    public function __construct(
        public Carbon|string|null $last_updated_after = null,
        public Carbon|string|null $last_updated_before = null,
        public ?int $days = null,
    ) {
        $this->sanitizeDates();
    }

    public function transform(): array
    {
        $params = [
            'ModTimeFrom' => $this->getZuluDate('last_updated_after'),
            'ModTimeTo' => $this->getZuluDate('last_updated_before'),
            'NumberOrDays' => $this->days,
        ];

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
