<?php

namespace Modules\Ebay\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Carbon\Carbon;
use Modules\Ebay\ApiDataTransferObjects\Concerns\EbayDatesTrait;
use Modules\Ebay\Entities\EbayProduct;
use Modules\Ebay\Enums\EbayLegacyGetProductActionsEnum;

class EbayGetProductsAdt implements ApiDataTransformerInterface
{
    use EbayDatesTrait;

    const DATES_TO_SANITIZE = [
        'created_after',
        'created_before',
    ];

    public function __construct(
        public Carbon|string|null $created_after = null,
        public Carbon|string|null $created_before = null,
        public ?bool $all = false,
//        public ?EbayLegacyGetProductActionsEnum $action = null,
        public int $pageNumber = 1,
    ) {
        $this->sanitizeDates();
    }

    public function transform(): array
    {
        $params = [];

        if (! $this->all) {
//            $this->action = EbayLegacyGetProductActionsEnum::GET_SELLER_LIST;
            // No created after specified, then we want to use GetSellerList and get only products created after the last one we have
            if (! $this->created_after) {
                $this->created_after = Carbon::parse(EbayProduct::latest('StartTimeUtc')->first()->StartTimeUtc);
                $params['StartTimeFrom'] = $this->getZuluDate('created_after');
            }
            // This will only really be used if we pass parameters via command
            if ($this->created_before) {
                $params['StartTimeTo'] = $this->getZuluDate('created_before');
            }
        } else {
//            $this->action = EbayLegacyGetProductActionsEnum::GET_MY_EBAY_SELLING;
        }

        $params['limit'] = 200;
        $params['pageNumber'] = $this->pageNumber;

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
