<?php

namespace Modules\Ebay\ApiDataTransferObjects;

use App\Abstractions\Integrations\ApiDataTransformerInterface;
use Carbon\Carbon;
use Exception;
use Modules\Ebay\ApiDataTransferObjects\Concerns\EbayDatesTrait;
use Modules\Ebay\Enums\EbayLegacyGetProductActionsEnum;

class EbayGetLegacyProductsAdt implements ApiDataTransformerInterface
{
    use EbayDatesTrait;

    const DATES_TO_SANITIZE = [
        'created_after',
        'created_before',
    ];

    public function __construct(
        public Carbon|string|null $created_after = null,
        public Carbon|string|null $created_before = null,
        public ?bool $all = false,
        public ?EbayLegacyGetProductActionsEnum $action = null,
        public int $pageNumber = 1,
    ) {
        $this->sanitizeDates();
    }

    /**
     * @throws Exception
     */
    public function transform(): array
    {
        $params = [];

        if (! $this->all) {
            $this->action = EbayLegacyGetProductActionsEnum::GET_SELLER_LIST;
            if ($this->created_after) {
                $params['StartTimeFrom'] = $this->getZuluDate('created_after');
            }
            else {
                throw new Exception('You must specify a created after date for product updates');
            }
            // This will only really be used if we pass parameters via command
            if ($this->created_before) {
                $params['StartTimeTo'] = $this->getZuluDate('created_before');
            }
            else {
                $params['StartTimeTo'] = Carbon::now('UTC')->format('Y-m-d\TH:i:s.v\Z');
            }
        } else {
            $this->action = EbayLegacyGetProductActionsEnum::GET_MY_EBAY_SELLING;
        }

        $params['limit'] = 200;
        $params['pageNumber'] = $this->pageNumber;

        return array_filter($params, fn ($param) => ! is_null($param));
    }
}
