<?php

namespace Modules\Ebay\Abstractions;

use Illuminate\Console\Command;
use Illuminate\Support\Collection;
use Modules\Ebay\Repositories\EbayIntegrationInstanceRepository;

abstract class AbstractEbayCommand extends Command
{
    protected EbayIntegrationInstanceRepository $integrationInstanceRepository;

    public function __construct()
    {
        parent::__construct();
        $this->integrationInstanceRepository = app(EbayIntegrationInstanceRepository::class);
    }

    protected function integrationInstances(): Collection
    {
        $integrationInstanceId = $this->hasArgument('integrationInstanceId') ? $this->argument('integrationInstanceId') : null;
        if ($integrationInstanceId !== null) {
            // If integrationInstanceId is provided, return a collection with a single instance
            return collect([$this->integrationInstanceRepository->getById($integrationInstanceId)]);
        }

        // If no integrationInstanceId is provided, return all instances
        return $this->integrationInstanceRepository->all();
    }
}
