<?php

namespace Modules\Amazon\Tests\Seeders;

use App\Models\InventoryAdjustment;
use App\Models\Product;
use App\Models\Warehouse;
use App\Services\InventoryManagement\InventoryManager;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonLedgerDetail;
use Modules\Amazon\Entities\AmazonReport;

class SeedLedgers
{
    public static function seed(): void
    {
        $fnsku = 'B00KBTQ7D4';
        $msku = '1727569-FBA';
        $asin = 'B00KBTQ7D4';
        $title = 'Optimate 3, TM-431, 7-Step 12V 0.8A Sealed Battery Saving Charger & maintainer';
        $disposition = 'SELLABLE';
        $country = 'US';
        $warehouse = Warehouse::first();
        $product = Product::where('sku', 'TM-431')->first();

        // Load file from current directory
        $fileContent = file_get_contents(__DIR__ . '/B00KBTQ7D4Ledgers.csv');

        $lines = collect(explode(PHP_EOL, $fileContent));

        $headers = [];
        $lines->first(function ($line) use (&$headers) {
            $headers = str_getcsv($line);
            return true;
        });

        $report = AmazonReport::factory()->create();

        $integrationInstance = AmazonIntegrationInstance::first();

        $lines->skip(1)->each(function ($line) use (
            $headers,
            $integrationInstance,
            $fnsku,
            $msku,
            $asin,
            $title,
            $report,
            $disposition,
            $country,
        ) {
            $values = str_getcsv($line);
            $row = array_combine($headers, $values);

            $data = [
                'integration_instance_id' => $integrationInstance->id,
                'event_datetime' => $row['event_datetime'],
                'amazon_report_id' => $report->id,
                'reconciled_at' => null,
                'sku_link_id' => null,
                'sku_link_type' => null,
                'json_object' => [
                    'date' => $row['date'],
                    'fnsku' => $fnsku,
                    'msku' => $msku,
                    'asin' => $asin,
                    'title' => $title,
                    'event_type' => $row['event_type'],
                    'reference_id' => $row['reference_id'],
                    'quantity' => $row['quantity'],
                    'fulfillment_center' => $row['fulfillment_center'],
                    'reason' => null,
                    'disposition' => $disposition,
                    'country' => $country
                ]
            ];
            AmazonFbaReportInventoryLedger::create($data);
        });
    }
}