<?php

namespace Modules\Amazon\Tests\Feature\Repositories;

use Illuminate\Foundation\Testing\WithFaker;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonProduct;
use Modules\Amazon\Repositories\AmazonProductRepository;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class AmazonProductRepositoryTest extends TestCase
{
    use FastRefreshDatabase;
    use WithFaker;

    private AmazonIntegrationInstance $amazonIntegrationInstance;

    private AmazonProductRepository $amazonProductRepository;

    protected function setUp(): void
    {
        parent::setUp();

        $this->amazonIntegrationInstance = AmazonIntegrationInstance::factory()
            ->hasSalesChannel()
            ->create();

        $this->amazonProductRepository = new AmazonProductRepository($this->amazonIntegrationInstance);
    }

    public function test_get_products_missing_catalog_item(): void
    {
        AmazonProduct::factory()
            ->for($this->amazonIntegrationInstance)
            ->count(10)
            ->create([
                'was_catalog_data_sync_attempted' => false,
            ]);

        $this->assertEquals(10, $this->amazonProductRepository->getProductsMissingCatalogItem($this->amazonIntegrationInstance)->count());
    }
}
