<?php

namespace Modules\Amazon\Tests\Feature\Managers\Helpers;

use Carbon\Carbon;
use Exception;
use Http;
use Illuminate\Http\Client\Request;
use Modules\Amazon\Entities\AmazonFeedSubmission;
use Modules\Amazon\Entities\AmazonOrder;
use Storage;

trait AmazonMockRequests
{
    private function mockRequest(string $url, array $response)
    {
        Http::fake([
            config('amazon.url_access_token') => Http::response([
                'access_token' => $this->faker->sha1(),
            ]),
            '*'.$url => Http::response($response),
        ]);
    }

    public function mockGetCatalogItems()
    {
        $this->mockRequest(config('catalog/2022-04-01/items').'?*', json_decode(file_get_contents(__DIR__.'/get_catalog_items.json'), true));
    }

    public function mockRefreshOrders()
    {
        //used for unique test logic
        $amazonOrder1 = AmazonOrder::factory()->make();
        $amazonOrder2 = AmazonOrder::factory()->make();

        Http::fake([
            config('amazon.url_access_token') => Http::response([
                'access_token' => $this->faker->sha1(),
            ]),
            '*'.config('amazon.get_orders_path').'?*' => Http::response([
                'payload' => [
                    'Orders' => [
                        [
                            'BuyerInfo' => [],
                            'AmazonOrderId' => $amazonOrder2->json_object['AmazonOrderId'],
                            'EarliestShipDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'SalesChannel' => 'Amazon.com',
                            'OrderStatus' => 'Shipped',
                            'NumberOfItemsShipped' => $this->faker->unique()->numberBetween(),
                            'OrderType' => 'StandardOrder',
                            'IsPremiumOrder' => false,
                            'IsPrime' => false,
                            'FulfillmentChannel' => 'AFN',
                            'NumberOfItemsUnshipped' => $this->faker->unique()->numberBetween(),
                            'HasRegulatedItems' => false,
                            'IsReplacementOrder' => 'false',
                            'IsSoldByAB' => false,
                            'LatestShipDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'ShipServiceLevel' => 'Standard',
                            'IsISPU' => false,
                            'MarketplaceId' => 'ATVPDKIKX0DER',
                            'PurchaseDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'ShippingAddress' => [],
                            'IsAccessPointOrder' => false,
                            'SellerOrderId' => $this->faker->unique()->numberBetween(),
                            'PaymentMethod' => 'Other',
                            'IsBusinessOrder' => false,
                            'OrderTotal' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => $this->faker->randomFloat(2, 0, 1000),
                            ],
                            'PaymentMethodDetails' => [],
                            'IsGlobalExpressEnabled' => false,
                            'LastUpdateDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'ShipmentServiceLevelCategory' => 'Standard',
                        ],
                        [
                            'BuyerInfo' => [],
                            'AmazonOrderId' => $amazonOrder1->json_object['AmazonOrderId'],
                            'EarliestShipDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'SalesChannel' => 'Amazon.com',
                            'OrderStatus' => 'Shipped',
                            'NumberOfItemsShipped' => $this->faker->unique()->numberBetween(),
                            'OrderType' => 'StandardOrder',
                            'IsPremiumOrder' => false,
                            'IsPrime' => false,
                            'FulfillmentChannel' => 'AFN',
                            'NumberOfItemsUnshipped' => $this->faker->unique()->numberBetween(),
                            'HasRegulatedItems' => false,
                            'IsReplacementOrder' => 'false',
                            'IsSoldByAB' => false,
                            'LatestShipDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'ShipServiceLevel' => 'Standard',
                            'IsISPU' => false,
                            'MarketplaceId' => 'ATVPDKIKX0DER',
                            'PurchaseDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'ShippingAddress' => [],
                            'IsAccessPointOrder' => false,
                            'SellerOrderId' => $this->faker->unique()->numberBetween(),
                            'PaymentMethod' => 'Other',
                            'IsBusinessOrder' => false,
                            'OrderTotal' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => $this->faker->randomFloat(2, 0, 1000),
                            ],
                            'PaymentMethodDetails' => [],
                            'IsGlobalExpressEnabled' => false,
                            'LastUpdateDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'ShipmentServiceLevelCategory' => 'Standard',
                        ],
                        [
                            'BuyerInfo' => [],
                            'AmazonOrderId' => $amazonOrder1->json_object['AmazonOrderId'],
                            'EarliestShipDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'SalesChannel' => 'Amazon.com',
                            'OrderStatus' => 'Shipped',
                            'NumberOfItemsShipped' => $this->faker->unique()->numberBetween(),
                            'OrderType' => 'StandardOrder',
                            'IsPremiumOrder' => false,
                            'IsPrime' => false,
                            'FulfillmentChannel' => 'AFN',
                            'NumberOfItemsUnshipped' => $this->faker->unique()->numberBetween(),
                            'HasRegulatedItems' => false,
                            'IsReplacementOrder' => 'false',
                            'IsSoldByAB' => false,
                            'LatestShipDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'ShipServiceLevel' => 'Standard',
                            'IsISPU' => false,
                            'MarketplaceId' => 'ATVPDKIKX0DER',
                            'PurchaseDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'ShippingAddress' => [],
                            'IsAccessPointOrder' => false,
                            'SellerOrderId' => $this->faker->unique()->numberBetween(),
                            'PaymentMethod' => 'Other',
                            'IsBusinessOrder' => false,
                            'OrderTotal' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => $this->faker->randomFloat(2, 0, 1000),
                            ],
                            'PaymentMethodDetails' => [],
                            'IsGlobalExpressEnabled' => false,
                            'LastUpdateDate' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                            'ShipmentServiceLevelCategory' => 'Standard',
                        ],
                    ],
                ],
            ]),
            '*/orders/v0/orders/*/orderItems' => Http::response([
                'payload' => [
                    'OrderItems' => [
                        [
                            'TaxCollection' => [
                                'Model' => 'MarketplaceFacilitator',
                                'ResponsibleParty' => 'Amazon Services, Inc.',
                            ],
                            'ProductInfo' => [
                                'NumberOfItems' => '1',
                            ],
                            'BuyerInfo' => [],
                            'ItemTax' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.78',
                            ],
                            'QuantityShipped' => 1,
                            'ItemPrice' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '12.95',
                            ],
                            'ASIN' => 'B0022ZZULK',
                            'SellerSKU' => '1722575-FBA',
                            'Title' => 'Tecmate Optimate Cable O-01, Weatherproof Battery Lead, powersport',
                            'IsGift' => 'false',
                            'IsTransparency' => false,
                            'QuantityOrdered' => $this->faker->numberBetween(1, 10),
                            'PromotionDiscountTax' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.00',
                            ],
                            'PromotionDiscount' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.00',
                            ],
                            'OrderItemId' => $this->faker->randomNumber(),
                        ],
                        [
                            'TaxCollection' => [
                                'Model' => 'MarketplaceFacilitator',
                                'ResponsibleParty' => 'Amazon Services, Inc.',
                            ],
                            'ProductInfo' => [
                                'NumberOfItems' => '1',
                            ],
                            'BuyerInfo' => [],
                            'ItemTax' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.78',
                            ],
                            'QuantityShipped' => 1,
                            'ItemPrice' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '12.95',
                            ],
                            'ASIN' => 'B0022ZZULK',
                            'SellerSKU' => '1722575-FBA',
                            'Title' => 'Tecmate Optimate Cable O-01, Weatherproof Battery Lead, powersport',
                            'IsGift' => 'false',
                            'IsTransparency' => false,
                            'QuantityOrdered' => $this->faker->numberBetween(1, 10),
                            'PromotionDiscountTax' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.00',
                            ],
                            'PromotionDiscount' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.00',
                            ],
                            'OrderItemId' => $this->faker->randomNumber(),
                        ],
                    ],
                ],
            ]),
            '*/tokens/2021-03-01/restrictedDataToken' => Http::response([
                'restrictedDataToken' => $this->faker->sha1(),
            ]),
        ]);
    }

    /**
     * Mock get order items API.
     */
    public function mockRefreshOrderItems(): void
    {
        $amazonOrder = AmazonOrder::factory()->create()->fresh();

        Http::fake([
            config('amazon.url_access_token') => Http::response([
                'access_token' => $this->faker->sha1(),
            ]),
            "*/orders/v0/orders/$amazonOrder->AmazonOrderId/orderItems" => Http::response([
                'payload' => [
                    'OrderItems' => [
                        [
                            'TaxCollection' => [
                                'Model' => 'MarketplaceFacilitator',
                                'ResponsibleParty' => 'Amazon Services, Inc.',
                            ],
                            'ProductInfo' => [
                                'NumberOfItems' => '1',
                            ],
                            'BuyerInfo' => [],
                            'ItemTax' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.78',
                            ],
                            'QuantityShipped' => 1,
                            'ItemPrice' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '12.95',
                            ],
                            'ASIN' => 'B0022ZZULK',
                            'SellerSKU' => '1722575-FBA',
                            'Title' => 'Tecmate Optimate Cable O-01, Weatherproof Battery Lead, powersport',
                            'IsGift' => 'false',
                            'IsTransparency' => false,
                            'QuantityOrdered' => $this->faker->numberBetween(1, 10),
                            'PromotionDiscountTax' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.00',
                            ],
                            'PromotionDiscount' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.00',
                            ],
                            'OrderItemId' => $this->faker->randomNumber(),
                        ],
                        [
                            'TaxCollection' => [
                                'Model' => 'MarketplaceFacilitator',
                                'ResponsibleParty' => 'Amazon Services, Inc.',
                            ],
                            'ProductInfo' => [
                                'NumberOfItems' => '1',
                            ],
                            'BuyerInfo' => [],
                            'ItemTax' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.78',
                            ],
                            'QuantityShipped' => 1,
                            'ItemPrice' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '12.95',
                            ],
                            'ASIN' => 'B0022ZZULK',
                            'SellerSKU' => '1722575-FBA',
                            'Title' => 'Tecmate Optimate Cable O-01, Weatherproof Battery Lead, powersport',
                            'IsGift' => 'false',
                            'IsTransparency' => false,
                            'QuantityOrdered' => $this->faker->numberBetween(1, 10),
                            'PromotionDiscountTax' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.00',
                            ],
                            'PromotionDiscount' => [
                                'CurrencyCode' => 'USD',
                                'Amount' => '0.00',
                            ],
                            'OrderItemId' => $this->faker->randomNumber(),
                        ],
                    ],
                ],
            ]),
        ]);
    }

    public function mockProductReport(string $filename)
    {
        Storage::disk('amazon_reports')->put($filename, file_get_contents(__DIR__.'/1023389019331.tsv'));
    }

    public function mockReport(string $filename)
    {
        Storage::disk('amazon_reports')->put($filename, file_get_contents(__DIR__.'/'.$filename));
    }

    public function mockRefreshFeed(AmazonFeedSubmission $amazonFeedSubmission)
    {
        $url = fake()->url();

        $salesOrder1 = $amazonFeedSubmission->salesOrderFulfillments[0];
        $salesOrder2 = $amazonFeedSubmission->salesOrderFulfillments[1];

        Http::fake([
            config('amazon.url_access_token') => Http::response([
                'access_token' => $this->faker->sha1(),
            ]),
            '*/feeds/2021-06-30/feeds/'.$amazonFeedSubmission->feedId => Http::response([
                'processingEndTime' => '2023-11-28T23:17:46+00:00',
                'processingStatus' => 'IN_PROGRESS',
                'marketplaceIds' => [
                    0 => 'ATVPDKIKX0DER',
                ],
                'feedId' => $amazonFeedSubmission->feedId,
                'feedType' => 'POST_ORDER_FULFILLMENT_DATA',
                'createdTime' => '2023-11-28T23:17:02+00:00',
                'processingStartTime' => '2023-11-28T23:17:09+00:00',
                'resultFeedDocumentId' => 'amzn1.tortuga.4.na.5f27621b-f249-4333-830a-27465ff2c7cb.TXIFKNYVLXT8P',
            ]),

            '*/feeds/2021-06-30/documents/*' => Http::response([
                'processingEndTime' => '2023-11-28T23:17:46+00:00',
                'processingStatus' => 'IN_PROGRESS',
                'marketplaceIds' => [
                    0 => 'ATVPDKIKX0DER',
                ],
                'feedId' => $amazonFeedSubmission->feedId,
                'feedType' => 'POST_ORDER_FULFILLMENT_DATA',
                'createdTime' => '2023-11-28T23:17:02+00:00',
                'processingStartTime' => '2023-11-28T23:17:09+00:00',
                'resultFeedDocumentId' => 'amzn1.tortuga.4.na.5f27621b-f249-4333-830a-27465ff2c7cb.TXIFKNYVLXT8P',
                'url' => $url,
            ]),
            $url => Http::response('<?xml version="1.0" encoding="UTF-8"?>
                                    <AmazonEnvelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="amzn-envelope.xsd">
                                            <Header>
                                                    <DocumentVersion>1.02</DocumentVersion>
                                                    <MerchantIdentifier>A1X7T0NB572XNW</MerchantIdentifier>
                                            </Header>
                                            <MessageType>ProcessingReport</MessageType>
                                            <Message>
                                                    <MessageID>1</MessageID>
                                                    <ProcessingReport>
                                                            <DocumentTransactionID>1265831019752</DocumentTransactionID>
                                                            <StatusCode>Complete</StatusCode>
                                                            <ProcessingSummary MarketplaceName="www.amazon.com">
                                                                    <MessagesProcessed>2</MessagesProcessed>
                                                                    <MessagesSuccessful>0</MessagesSuccessful>
                                                                    <MessagesWithError>2</MessagesWithError>
                                                                    <MessagesWithWarning>0</MessagesWithWarning>
                                                            </ProcessingSummary>
                                                            <Result>
                                                                    <MessageID>1</MessageID>
                                                                    <ResultCode>Error</ResultCode>
                                                                    <ResultMessageCode>18030</ResultMessageCode>
                                                                    <ResultDescription>The order id you provided (('.$salesOrder1->salesOrder->sales_order_number.')) was not associated with your merchant. Please submit your OrderAcknowledgment or OrderFulfillment message using the merchant account that originally received the order in an order report.</ResultDescription>
                                                                    <AdditionalInfo>
                                                                            <AmazonOrderID>'.$salesOrder1->salesOrder->sales_order_number.'</AmazonOrderID>
                                                                    </AdditionalInfo>
                                                            </Result>
                                                            <Result>
                                                                    <MessageID>2</MessageID>
                                                                    <ResultCode>Error</ResultCode>
                                                                    <ResultMessageCode>18030</ResultMessageCode>
                                                                    <ResultDescription>The order id you provided (('.$salesOrder2->salesOrder->sales_order_number.')) was not associated with your merchant. Please submit your OrderAcknowledgment or OrderFulfillment message using the merchant account that originally received the order in an order report.</ResultDescription>
                                                                    <AdditionalInfo>
                                                                            <AmazonOrderID>'.$salesOrder2->salesOrder->sales_order_number.'</AmazonOrderID>
                                                                    </AdditionalInfo>
                                                            </Result>
                                                    </ProcessingReport>
                                            </Message>
                                    </AmazonEnvelope>'),
        ]);
    }

    public function mockRefreshFinancialEventGroups()
    {
        Http::fake([
            config('amazon.url_access_token') => Http::response([
                'access_token' => $this->faker->sha1(),
            ]),
            '*/finances/v0/financialEventGroups*' => Http::response([
                'payload' => [
                    'FinancialEventGroupList' => [
                        [
                            'FinancialEventGroupId' => 'ZKLSeJQRaN2EL6O__MYiLaNIbxVLxS7oy639I7IZZEc',
                            'ProcessingStatus' => 'Open',
                            'OriginalTotal' => [
                                'CurrencyCode' => 'CAD',
                                'CurrencyAmount' => 103.62,
                            ],
                            'ConvertedTotal' => [
                                'CurrencyCode' => 'USD',
                                'CurrencyAmount' => 76.42,
                            ],
                            'BeginningBalance' => [
                                'CurrencyCode' => 'CAD',
                                'CurrencyAmount' => 0,
                            ],
                            'FinancialEventGroupStart' => '2023-12-20T19:46:12Z',
                        ],
                        [
                            'FinancialEventGroupId' => '-2Yo3YFk0XG2ovBR7OTMGLy2wcHgMWPNGkSoLpqU_-M',
                            'ProcessingStatus' => 'Open',
                            'OriginalTotal' => [
                                'CurrencyCode' => 'USD',
                                'CurrencyAmount' => 0,
                            ],
                            'BeginningBalance' => [
                                'CurrencyCode' => 'USD',
                                'CurrencyAmount' => 0,
                            ],
                            'FinancialEventGroupStart' => '2023-12-20T07:34:20Z',
                        ],
                        [
                            'FinancialEventGroupId' => 'fSljvL8CgniEVeoimj7f96Hrp74CDddkEQ4C9zdFp5c',
                            'ProcessingStatus' => 'Open',
                            'OriginalTotal' => [
                                'CurrencyCode' => 'USD',
                                'CurrencyAmount' => 18731.41,
                            ],
                            'BeginningBalance' => [
                                'CurrencyCode' => 'USD',
                                'CurrencyAmount' => 0,
                            ],
                            'FinancialEventGroupStart' => '2023-12-12T15:24:06Z',
                        ],
                        [
                            'FinancialEventGroupId' => 'Q6UU6iZN6KarvgCOpRTvc8MA9bu2PixZT7MqLfhaQJg',
                            'ProcessingStatus' => 'Closed',
                            'FundTransferStatus' => 'Processing',
                            'OriginalTotal' => [
                                'CurrencyCode' => 'CAD',
                                'CurrencyAmount' => 1047.54,
                            ],
                            'ConvertedTotal' => [
                                'CurrencyCode' => 'USD',
                                'CurrencyAmount' => 772.54,
                            ],
                            'FundTransferDate' => '2023-12-21T19:48:28Z',
                            'AccountTail' => '3239',
                            'BeginningBalance' => [
                                'CurrencyCode' => 'CAD',
                                'CurrencyAmount' => 0,
                            ],
                            'FinancialEventGroupStart' => '2023-12-06T19:46:12Z',
                            'FinancialEventGroupEnd' => '2023-12-20T19:46:12Z',
                        ],
                    ],
                ],
            ]),
        ]);
    }

    public function mockRefreshFinancialEvents()
    {
        Http::fake([
            config('amazon.url_access_token') => Http::response([
                'access_token' => $this->faker->sha1(),
            ]),
            '*/finances/v0/financialEvents*' => Http::response([
                'payload' => [
                    'FinancialEvents' => [
                        'ShipmentEventList' => [
                            [
                                'AmazonOrderId' => '112-6644981-7758668',
                                'SellerOrderId' => '112-6644981-7758668',
                                'MarketplaceName' => 'Amazon.com',
                                'PostedDate' => '2024-04-17T21:18:39Z',
                                'ShipmentItemList' => [
                                    [
                                        'SellerSKU' => '2955433-FBA',
                                        'OrderItemId' => '98357958304641',
                                        'QuantityShipped' => 1,
                                        'ItemChargeList' => [
                                            [
                                                'ChargeType' => 'Principal',
                                                'ChargeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 152.45,
                                                ],
                                            ],
                                            [
                                                'ChargeType' => 'Tax',
                                                'ChargeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 9.15,
                                                ],
                                            ],
                                            [
                                                'ChargeType' => 'GiftWrap',
                                                'ChargeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                            [
                                                'ChargeType' => 'GiftWrapTax',
                                                'ChargeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                            [
                                                'ChargeType' => 'ShippingCharge',
                                                'ChargeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                            [
                                                'ChargeType' => 'ShippingTax',
                                                'ChargeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                        ],
                                        'ItemFeeList' => [
                                            [
                                                'FeeType' => 'FBAPerOrderFulfillmentFee',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                            [
                                                'FeeType' => 'FBAPerUnitFulfillmentFee',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => -5.78,
                                                ],
                                            ],
                                            [
                                                'FeeType' => 'FBAWeightBasedFee',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                            [
                                                'FeeType' => 'Commission',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => -18.29,
                                                ],
                                            ],
                                            [
                                                'FeeType' => 'FixedClosingFee',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                            [
                                                'FeeType' => 'GiftwrapChargeback',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                            [
                                                'FeeType' => 'ShippingChargeback',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                            [
                                                'FeeType' => 'VariableClosingFee',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 0,
                                                ],
                                            ],
                                        ],
                                        'ItemTaxWithheldList' => [
                                            [
                                                'TaxCollectionModel' => 'MarketplaceFacilitator',
                                                'TaxesWithheld' => [
                                                    [
                                                        'ChargeType' => 'MarketplaceFacilitatorTax-Principal',
                                                        'ChargeAmount' => [
                                                            'CurrencyCode' => 'USD',
                                                            'CurrencyAmount' => -9.15,
                                                        ],
                                                    ],
                                                ],
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                        ],
                        'ShipmentSettleEventList' => [
                        ],
                        'RefundEventList' => [
                            [
                                'AmazonOrderId' => '112-6644981-7758668',
                                'SellerOrderId' => '112-6644981-7758668',
                                'MarketplaceName' => 'Amazon.com',
                                'PostedDate' => '2024-05-18T13:00:24Z',
                                'ShipmentItemAdjustmentList' => [
                                    [
                                        'SellerSKU' => '2955433-FBA',
                                        'OrderAdjustmentItemId' => '98357958304641',
                                        'QuantityShipped' => 1,
                                        'ItemChargeAdjustmentList' => [
                                            [
                                                'ChargeType' => 'Tax',
                                                'ChargeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => -9.15,
                                                ],
                                            ],
                                            [
                                                'ChargeType' => 'Principal',
                                                'ChargeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => -152.45,
                                                ],
                                            ],
                                        ],
                                        'ItemFeeAdjustmentList' => [
                                            [
                                                'FeeType' => 'Commission',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => 18.29,
                                                ],
                                            ],
                                            [
                                                'FeeType' => 'RefundCommission',
                                                'FeeAmount' => [
                                                    'CurrencyCode' => 'USD',
                                                    'CurrencyAmount' => -3.66,
                                                ],
                                            ],
                                        ],
                                        'ItemTaxWithheldList' => [
                                            [
                                                'TaxCollectionModel' => 'MarketplaceFacilitator',
                                                'TaxesWithheld' => [
                                                    [
                                                        'ChargeType' => 'MarketplaceFacilitatorTax-Principal',
                                                        'ChargeAmount' => [
                                                            'CurrencyCode' => 'USD',
                                                            'CurrencyAmount' => 9.15,
                                                        ],
                                                    ],
                                                ],
                                            ],
                                        ],
                                    ],
                                ],
                            ],
                        ],
                        'GuaranteeClaimEventList' => [
                        ],
                        'ChargebackEventList' => [
                        ],
                        'PayWithAmazonEventList' => [
                        ],
                        'ServiceProviderCreditEventList' => [
                        ],
                        'RetrochargeEventList' => [
                        ],
                        'RentalTransactionEventList' => [
                        ],
                        'PerformanceBondRefundEventList' => [
                        ],
                        'ProductAdsPaymentEventList' => [
                        ],
                        'ServiceFeeEventList' => [
                            [
                                'AmazonOrderId' => '112-6644981-7758668',
                                'SellerSKU' => '2955433-FBA',
                                'FeeDescription' => 'iCarsoft MB V3.0 for Mercedes-Benz/Sprinter/Smart Diagnostic Tool with auto VIN/Quick Test/Actuation Test',
                            ],
                            [
                                'AmazonOrderId' => '112-6644981-7758668',
                                'FeeList' => [
                                    [
                                        'FeeType' => 'FBACustomerReturnPerUnitFee',
                                        'FeeAmount' => [
                                            'CurrencyCode' => 'USD',
                                            'CurrencyAmount' => 0,
                                        ],
                                    ],
                                ],
                                'SellerSKU' => '2955433-FBA',
                                'FeeDescription' => 'iCarsoft MB V3.0 for Mercedes-Benz/Sprinter/Smart Diagnostic Tool with auto VIN/Quick Test/Actuation Test',
                            ],
                        ],
                        'SellerDealPaymentEventList' => [
                        ],
                        'DebtRecoveryEventList' => [
                        ],
                        'LoanServicingEventList' => [
                        ],
                        'AdjustmentEventList' => [
                            [
                                'AdjustmentType' => 'ReturnPostageBilling_Tracking',
                                'PostedDate' => '2024-08-21T20:57:46Z',
                                'AdjustmentAmount' => [
                                    'CurrencyCode' => 'USD',
                                    'CurrencyAmount' => 0,
                                ],
                            ],
                            [
                                'AdjustmentType' => 'Other',
                                'PostedDate' => '2024-08-21T20:57:46Z',
                                'AdjustmentAmount' => [
                                    'CurrencyCode' => 'USD',
                                    'CurrencyAmount' => 0,
                                ],
                            ],
                            [
                                'AdjustmentType' => 'ReturnPostageBilling_Postage',
                                'PostedDate' => '2024-08-21T20:57:46Z',
                                'AdjustmentAmount' => [
                                    'CurrencyCode' => 'USD',
                                    'CurrencyAmount' => -4.43,
                                ],
                            ],
                            [
                                'AdjustmentType' => 'ReturnPostageBilling_TransactionFee',
                                'PostedDate' => '2024-08-21T20:57:46Z',
                                'AdjustmentAmount' => [
                                    'CurrencyCode' => 'USD',
                                    'CurrencyAmount' => 0,
                                ],
                            ],
                            [
                                'AdjustmentType' => 'PostageBilling_PostageAdjustment',
                                'PostedDate' => '2024-09-29T14:26:44Z',
                                'AdjustmentAmount' => [
                                    'CurrencyCode' => 'USD',
                                    'CurrencyAmount' => -2.13,
                                ],
                            ],
                        ],
                        'SAFETReimbursementEventList' => [
                        ],
                        'SellerReviewEnrollmentPaymentEventList' => [
                        ],
                        'FBALiquidationEventList' => [
                        ],
                        'CouponPaymentEventList' => [
                        ],
                        'ImagingServicesFeeEventList' => [
                        ],
                        'NetworkComminglingTransactionEventList' => [
                        ],
                        'AffordabilityExpenseEventList' => [
                        ],
                        'AffordabilityExpenseReversalEventList' => [
                        ],
                        'RemovalShipmentEventList' => [
                        ],
                        'RemovalShipmentAdjustmentEventList' => [
                        ],
                        'TrialShipmentEventList' => [
                        ],
                        'TDSReimbursementEventList' => [
                        ],
                        'AdhocDisbursementEventList' => [
                        ],
                        'TaxWithholdingEventList' => [
                        ],
                        'ChargeRefundEventList' => [
                        ],
                        'FailedAdhocDisbursementEventList' => [
                        ],
                        'ValueAddedServiceChargeEventList' => [
                        ],
                        'CapacityReservationBillingEventList' => [
                        ],
                    ],
                ],
            ]),
        ]);
    }

    public function mockCreateReport(): void
    {
        Http::fake([
            config('amazon.url_access_token') => Http::response([
                'access_token' => $this->faker->sha1(),
            ]),
            '*/reports/2021-06-30/reports' => function (Request $request) {
                if ($request->data()['dataEndTime'] == Carbon::parse('2024-01-05')->toIso8601ZuluString()) {
                    return Http::response([
                        'reportId' => 1234,
                        'marketplaceIds' => ['ATVPDKIKX0DER'],
                    ]);
                }
                if ($request->data()['dataEndTime'] == Carbon::parse('2024-01-10')->toIso8601ZuluString()) {
                    return Http::response([
                        'reportId' => 5678,
                        'marketplaceIds' => ['ATVPDKIKX0DER'],
                    ]);
                }
                throw new Exception('Mock create report end date not handled '.$request->data()['dataEndTime']);
            },
        ]);
    }
}
