<?php

namespace Modules\Amazon\Tests\Feature\Controllers;

use App\Models\User;
use Laravel\Sanctum\Sanctum;
use Modules\Amazon\Entities\AmazonFbaReportCustomerReturn;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Plannr\Laravel\FastRefreshDatabase\Traits\FastRefreshDatabase;
use Tests\TestCase;

class AmazonFbaLpnLookupControllerTest extends TestCase
{
    use FastRefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        Sanctum::actingAs(User::first());
    }

    public function test_amazon_fba_lpn_lookup_controller()
    {
        $amazonIntegrationInstance = AmazonIntegrationInstance::factory()->create();

        $customerReturn = AmazonFbaReportCustomerReturn::factory()->create([
            'integration_instance_id' => $amazonIntegrationInstance->id,
        ]);

        $jsonData = $customerReturn->json_object;
        $jsonData['license_plate_number'] = '123456789';
        $customerReturn->json_object = $jsonData;
        $customerReturn->save();

        $response = $this->getJson(route('amazon.lpn-lookup', $amazonIntegrationInstance->id) . '?lpn=123456789');

        $response->assertOk();

        $data = $response->json('data');

        $this->assertEquals($customerReturn->id, $data['id']);
    }
}
