<?php

namespace Modules\Amazon\Tests;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;

trait AmazonMockRequests
{
    public function mockRefreshOrders(): void
    {
        Http::fake([
            '*/orders?*' => Http::response(AmazonTestingData::getOrders()),
        ]);
    }

    public function mockRefreshOrderItems(): void
    {
        Http::fake([
            '*/orders/*/orders/*/orderItems*' => Http::response(AmazonTestingData::getOrderItems()),
        ]);
    }

    public function mockSearchCatalogItems(): void
    {
        Http::fake([
            '*/catalog/*/items?*' => Http::response(AmazonTestingData::getCatalogData()),
        ]);
    }

    public function mockRefreshTokenFromAuthCode(): void
    {
        Http::fake([
            config('amazon.url_access_token') => Http::response(AmazonTestingData::getRefreshTokenFromAuthCode()),
        ]);
    }

    public function mockGetAccessToken(): void
    {
        Http::fake([
            config('amazon.url_access_token') => Http::response(AmazonTestingData::getAccessToken()),
        ]);
    }

    public function mockGetRestrictedDataToken(): void
    {
        Http::fake([
            '*/tokens/*/restrictedDataToken*' => Http::response(AmazonTestingData::getRestrictedDataToken()),
        ]);
    }

    public function mockCreateReport(): void
    {
        Http::fake([
            '*/reports/*/reports' => Http::sequence()
                ->push(AmazonTestingData::createReport())
                ->push(AmazonTestingData::createCAReport())
                ->push(AmazonTestingData::createMXReport())
                ->push(AmazonTestingData::createBRReport())
                ->whenEmpty(Http::response())
        ]);
    }

    public function mockGetReport(): void
    {
        Http::fake([
            '*/reports/*/reports/*' => Http::sequence()
                ->push(AmazonTestingData::getReportUSInProgress())
                ->push(AmazonTestingData::getReportCAInProgress())
                ->push(AmazonTestingData::getReportMXInProgress())
                ->push(AmazonTestingData::getReportBRInProgress())
                ->push(AmazonTestingData::getReportUSDone())
                ->whenEmpty(Http::response())
        ]);
    }

    public function mockGetReportDocument(): void
    {
        Http::fake([
            '*/reports/*/documents/*' => Http::response(AmazonTestingData::getReportUSDocument()),
        ]);
    }

    public function mockGetDocument(): void
    {
        Http::fake([
            'https://123' => Http::response(arrayToTsv(AmazonTestingData::getProducts()))
        ]);
    }

    public function mockGetInboundShipments(): void
    {
        Http::fake([
            '*/fba/inbound/v0/shipments?*' => Http::response(AmazonTestingData::getInboundShipments()),
        ]);
    }

    public function mockGetInboundShipmentItems(): void
    {
        Http::fake([
            '*/fba/inbound/v0/shipments/*/items' => Http::response(AmazonTestingData::getInboundShipmentItems()),
        ]);
    }

    public function mockGetMarketplaceParticipations(): void
    {
        Http::fake([
            '*/sellers/*/marketplaceParticipations' => Http::response(AmazonTestingData::getMarketplaceParticipations())
        ]);
    }

    public function mockListInboundPlans(): void
    {
        Http::fake([
            '*/inbound/fba/2024-03-20/inboundPlans?*' => Http::response(AmazonTestingData::listInboundPlans()),
            '*/inbound/fba/2024-03-20/inboundPlans/wff5bf3b6e-ada8-4b3c-8cf7-b43796033a57' => Http::response(AmazonTestingData::getInboundPlan1()),
            '*/inbound/fba/2024-03-20/inboundPlans/wf52bdb8a9-d197-4d95-9f60-07d2293b587d' => Http::response(AmazonTestingData::getInboundPlan2()),
        ]);
    }

    public function mockListInboundPlanItems(): void
    {
        Http::fake([
            '*/inbound/fba/2024-03-20/inboundPlans/wff5bf3b6e-ada8-4b3c-8cf7-b43796033a57/items' => Http::response(AmazonTestingData::listInboundPlanItems1()),
            '*/inbound/fba/2024-03-20/inboundPlans/wf52bdb8a9-d197-4d95-9f60-07d2293b587d/items' => Http::response(AmazonTestingData::listInboundPlanItems2()),
        ]);
    }

    public function mockGetNewInboundShipment(): void
    {
        Http::fake([
            '*/inbound/fba/2024-03-20/inboundPlans/wff5bf3b6e-ada8-4b3c-8cf7-b43796033a57/shipments/sh520dd36b-ba96-4943-bb94-c733489b94d4' => Http::response(AmazonTestingData::getNewInboundShipment1()),
            '*/inbound/fba/2024-03-20/inboundPlans/wf52bdb8a9-d197-4d95-9f60-07d2293b587d/shipments/she29cf4f2-dfda-4d7d-a783-82f2a63c472d' => Http::response(AmazonTestingData::getNewInboundShipment2()),
        ]);
    }

    public function mockListShipmentItems(): void
    {
        Http::fake([
            '*/inbound/fba/2024-03-20/inboundPlans/wff5bf3b6e-ada8-4b3c-8cf7-b43796033a57/shipments/sh520dd36b-ba96-4943-bb94-c733489b94d4/items' => Http::response(AmazonTestingData::listShipmentItems1()),
            '*/inbound/fba/2024-03-20/inboundPlans/wf52bdb8a9-d197-4d95-9f60-07d2293b587d/shipments/she29cf4f2-dfda-4d7d-a783-82f2a63c472d/items' => Http::response(AmazonTestingData::listShipmentItems2()),
        ]);
    }

    public function mockListInboundShipmentBoxes(): void
    {
        Http::fake([
            '*/inbound/fba/2024-03-20/inboundPlans/*/shipments/*/boxes' => Http::response(AmazonTestingData::listInboundShipmentBoxes()),
        ]);
    }

//    public function mockOutboundFulfillmentOrder(): void
//    {
//        Http::fake([
//            '*/fba/outbound/2020-07-01/fulfillmentOrders' => Http::response(AmazonTestingData::getFulfillmentOrder()),
//        ]);
//    }

    public function mockGetFulfillmentOrder(): void
    {
        Http::fake([
            '*/fba/outbound/2020-07-01/fulfillmentOrders/123.1' => Http::response(AmazonTestingData::getFulfillmentOrder()),
        ]);
    }

    public function mockListAllFulfillmentOrders(): void
    {
        Http::fake([
            '*/fba/outbound/2020-07-01/fulfillmentOrders*' => Http::response(AmazonTestingData::listAllFulfillmentOrders()),
        ]);
    }
}
