<?php

use Illuminate\Support\Facades\Route;
use Modules\Amazon\Http\Controllers\AmazonAuthenticationController;
use Modules\Amazon\Http\Controllers\AmazonFbaInboundShipmentController;
use Modules\Amazon\Http\Controllers\AmazonFbaLedgerController;
use Modules\Amazon\Http\Controllers\AmazonFbaReportCustomerReturnController;
use Modules\Amazon\Http\Controllers\AmazonFbaReportRemovalShipmentController;
use Modules\Amazon\Http\Controllers\AmazonFbaReportShipmentController;
use Modules\Amazon\Http\Controllers\AmazonOrderController;
use Modules\Amazon\Http\Controllers\AmazonProductController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::prefix('export/amazon/{integrationInstance}')->name('amazon.')->group(function () {
    Route::get('products', [AmazonProductController::class, 'exportForIntegration'])->name('products.export-download');
    Route::get('orders', [AmazonOrderController::class, 'exportForIntegration'])->name('orders.export-download');
    Route::get('ledgers', [AmazonFbaLedgerController::class, 'exportForIntegration']);
    Route::get('ledgers/customer-returns', [AmazonFbaReportCustomerReturnController::class, 'exportForIntegration']);
    Route::get('ledgers/shipments', [AmazonFbaReportShipmentController::class, 'exportForIntegration']);
    Route::get('ledgers/removal-shipments', [AmazonFbaReportRemovalShipmentController::class, 'exportForIntegration']);
    Route::get('inbound/shipments', [AmazonFbaInboundShipmentController::class, 'exportForIntegration']);
});

Route::prefix('amazon')->name('amazon.')->group(function () {
    Route::any('callback', [AmazonAuthenticationController::class, 'callback'])->name('callback');
});
