<?php

use Illuminate\Support\Facades\Route;
use Modules\Amazon\Http\Controllers\AmazonAuthenticationController;
use Modules\Amazon\Http\Controllers\AmazonFbaInboundShipFromMappingController;
use Modules\Amazon\Http\Controllers\AmazonFbaInboundShipmentController;
use Modules\Amazon\Http\Controllers\AmazonFbaInitialInventoryController;
use Modules\Amazon\Http\Controllers\AmazonFbaLedgerController;
use Modules\Amazon\Http\Controllers\AmazonFbaLpnLookupController;
use Modules\Amazon\Http\Controllers\AmazonFbaRemovalOrderController;
use Modules\Amazon\Http\Controllers\AmazonFbaReportCustomerReturnController;
use Modules\Amazon\Http\Controllers\AmazonFbaReportInventoryController;
use Modules\Amazon\Http\Controllers\AmazonFbaReportInventoryLedgerSummaryController;
use Modules\Amazon\Http\Controllers\AmazonFbaReportRemovalShipmentController;
use Modules\Amazon\Http\Controllers\AmazonFbaReportRestockController;
use Modules\Amazon\Http\Controllers\AmazonFbaReportShipmentController;
use Modules\Amazon\Http\Controllers\AmazonFinancialEventGroupController;
use Modules\Amazon\Http\Controllers\AmazonFinancialEventTypeNominalCodeMappingController;
use Modules\Amazon\Http\Controllers\AmazonFinancialShipmentEventController;
use Modules\Amazon\Http\Controllers\AmazonFnskuProductController;
use Modules\Amazon\Http\Controllers\AmazonFulfillmentController;
use Modules\Amazon\Http\Controllers\AmazonIntegrationInstanceController;
use Modules\Amazon\Http\Controllers\AmazonLedgerSummaryAdjustmentController;
use Modules\Amazon\Http\Controllers\AmazonNewFbaInboundPlanController;
use Modules\Amazon\Http\Controllers\AmazonNewFbaInboundShipmentController;
use Modules\Amazon\Http\Controllers\AmazonOrderController;
use Modules\Amazon\Http\Controllers\AmazonOutboundFulfillmentController;
use Modules\Amazon\Http\Controllers\AmazonProductController;
use Modules\Amazon\Http\Controllers\AmazonReportController;
use Modules\Amazon\Http\Controllers\AmazonReportSettlementDataController;
use Modules\Amazon\Http\Controllers\FbaInventoryValuationController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->group(function () {
    Route::salesChannel(
        'amazon',
        AmazonProductController::class,
        AmazonOrderController::class,
        AmazonFulfillmentController::class,
        AmazonAuthenticationController::class,
        AmazonIntegrationInstanceController::class,
    );
    Route::prefix('/amazon/{integrationInstance}')->name('amazon.')->group(function () {
        Route::apiResource('fba-inventory', AmazonFbaReportInventoryController::class)->only('show');
        Route::get('fba-inventory', [AmazonFbaReportInventoryController::class, 'indexForIntegration']);

        Route::prefix('reports')->name('reports.')->controller(AmazonReportController::class)->group(function () {
            Route::get('get-info', 'getInfo')->name('get-info');
            Route::post('{report}/sync', 'sync')->name('sync');
        });

        Route::prefix('report-requests')->name('report-requests.')->controller(AmazonReportController::class)->group(function () {
            Route::post('{reportRequest}/create-report', 'createReport')->name('create-report');
            Route::post('create-next', 'createNextRequest')->name('create-next');
        });

        Route::prefix('ledgers')->name('ledgers.')->group(function () {

            Route::prefix('customer-returns')->name('customer-returns.')->controller(AmazonFbaReportCustomerReturnController::class)->group(function () {
                Route::get('/', 'indexForIntegration')->name('index');
                Route::get('export', 'exportForIntegration')->name('export');
            });
            Route::apiResource('/customer-returns', AmazonFbaReportCustomerReturnController::class)->only('show');

            Route::prefix('shipments')->name('shipments.')->controller(AmazonFbaReportShipmentController::class)->group(function () {
                Route::get('/', 'indexForIntegration')->name('index');
                Route::get('export', 'exportForIntegration')->name('export');
            });
            Route::apiResource('/shipments', AmazonFbaReportShipmentController::class)->only('show');

            Route::prefix('removal-shipments')->name('removal-shipments.')->controller(AmazonFbaReportRemovalShipmentController::class)->group(function () {
                Route::get('/', 'indexForIntegration')->name('index');
                Route::get('export', 'exportForIntegration')->name('export');
            });
            Route::apiResource('/removal-shipments', AmazonFbaReportRemovalShipmentController::class)->only('show');

            Route::get('{amazonFbaReportInventoryLedger}/unmatched-detail', [AmazonFbaLedgerController::class, 'getUnmatchedDetailReports'])->name('unmatched-detail');
            Route::get('unmatched-ledgers', [AmazonFbaLedgerController::class, 'getUnmatchedLedgers'])->name('unmatched-ledgers');
            Route::post('{ledger}/link-to-detail-reports', [AmazonFbaLedgerController::class, 'linkToDetailReports'])->name('link-to-detail-reports');
            Route::get('export', [AmazonFbaLedgerController::class, 'exportForIntegration'])->name('export');
            Route::post('{ledger}/reconcile', [AmazonFbaLedgerController::class, 'reconcileLedger'])->name('reconcile');
            Route::post('reconcile-ledgers', [AmazonFbaLedgerController::class, 'reconcileLedgers'])->name('reconcile-ledgers');
            Route::post('fnsku/{fnskuProduct}/reconcile', [AmazonFbaLedgerController::class, 'reconcileFnskuLedgers'])->name('reconcile-fnsku-ledgers');
            Route::get('last-reconciled-date', [AmazonFbaLedgerController::class, 'getLastReconciledDate'])->name('last-reconciled-date');
            Route::get('reconciliation-report', [AmazonFbaLedgerController::class, 'getReconciliationReport'])->name('reconciliation-report');
            Route::post('reconcile-all', [AmazonFbaLedgerController::class, 'reconcileAll'])->name('reconcile-all');
            Route::post('{ledger}/unreconcile', [AmazonFbaLedgerController::class, 'unreconcileLedger'])->name('unreconcile');
            Route::post('unreconcile-ledgers', [AmazonFbaLedgerController::class, 'unreconcileLedgers'])->name('unreconcile-ledgers');
            Route::post('fnsku/{fnskuProduct}/unreconcile', [AmazonFbaLedgerController::class, 'unreconcileFnskuLedgers'])->name('unreconcile-fnsku-ledgers');
            Route::post('unreconcile-all', [AmazonFbaLedgerController::class, 'unreconcileAll'])->name('unreconcile-all');
            Route::post('{ledger}/create-inventory-adjustment', [AmazonFbaLedgerController::class, 'createInventoryAdjustmentFromLedger'])->name('create-inventory-adjustment');
            Route::get('/', [AmazonFbaLedgerController::class, 'indexForIntegration'])->name('index');

        });
        Route::apiResource('ledgers', AmazonFbaLedgerController::class)->only('show');

        Route::prefix('fnsku-products')->name('fnsku-products.')->controller(AmazonFnskuProductController::class)->group(function () {
            Route::get('/', 'indexForIntegration')->name('index');
            Route::post('/create', 'generateFnskuProducts')->name('create-fnsku-products');
            Route::post('/link-to-product', 'linkToProduct')->name('link-to-product');
        });
        Route::apiResource('fnsku-products', AmazonFnskuProductController::class)->only('show');

        Route::prefix('initial-inventory')->name('initial-inventory.')->controller(AmazonFbaInitialInventoryController::class)->group(function () {
            Route::get('/', 'indexForIntegration')->name('index');
            Route::post('{initialInventory}/reconcile', 'reconcile')->name('reconcile');
            Route::post('{initialInventory}/unreconcile', 'unreconcile')->name('unreconcile');
            Route::post('reconcile-all', 'reconcileAll')->name('reconcile-all');
            Route::post('reconcile', 'reconcileInitialInventories')->name('reconcile-initial-inventories');
            Route::post('unreconcile-all', 'unreconcileAll')->name('unreconcile-all');
            Route::post('unreconcile', 'unreconcileInitialInventories')->name('unreconcile-initial-inventories');
            Route::post('reconcile-for-fnskus', 'reconcileInitialInventoriesForFnskuProducts')->name('reconcile-for-fnskus');
            Route::post('unreconcile-for-fnskus', 'unreconcileInitialInventoriesForFnskuProducts')->name('unreconcile-for-fnskus');
        });
        Route::apiResource('initial-inventory', AmazonFbaInitialInventoryController::class)->only('show');

        Route::prefix('ledger-summaries')->name('ledger-summaries.')->controller(AmazonFbaReportInventoryLedgerSummaryController::class)->group(function () {
            Route::get('/', 'indexForIntegration')->name('index');
            Route::post('reconcile-all', 'reconcileAll')->name('reconcile-all');
            Route::post('{ledgerSummary}/reconcile', 'reconcile')->name('reconcile');
            Route::post('unreconcile-all', 'unreconcileAll')->name('unreconcile-all');
            Route::post('{ledgerSummary}/unreconcile', 'unreconcile')->name('unreconcile');
            Route::prefix('adjustments')->name('adjustments.')->controller(AmazonLedgerSummaryAdjustmentController::class)->group(function () {
                Route::get('/', 'indexForIntegration')->name('index');
            });
        });
        Route::apiResource('ledger-summaries', AmazonFbaReportInventoryLedgerSummaryController::class)->only('show');

        Route::get('fba-inventory-valuation', FbaInventoryValuationController::class)->name('fba-inventory-valuation');

        Route::prefix('inbound')->name('inbound.')->controller(AmazonFbaInboundShipmentController::class)->group(function () {
            Route::prefix('shipments')->group(function () {
                Route::post('refresh', 'refresh')->name('refresh');
                Route::get('unlinked', 'getUnlinkedShipments');
                Route::get('export', 'exportForIntegration')->name('export');
                Route::post('set-sent-before-initial-count', 'setSentBeforeInitialCount')->name('set-sent-before-initial-count');
                Route::get('/', 'indexForIntegration')->name('index');
            });
            Route::post('process', 'process')->name('process');
            Route::post('process-all', 'processAll')->name('process-all');
            Route::post('unprocess', 'unprocess')->name('unprocess');
            Route::prefix('ship-from-mappings')->name('ship-from-mappings.')->controller(AmazonFbaInboundShipFromMappingController::class)->group(function () {
                Route::get('/', 'index');
                Route::post('/', 'updateMappings');
            });
        });
        Route::apiResource('inbound/shipments', AmazonFbaInboundShipmentController::class)->only('show');

        Route::prefix('new-inbound')->name('new-inbound.')->group(function () {
            Route::prefix('plans')->name('plans.')->controller(AmazonNewFbaInboundPlanController::class)->group(function () {
                Route::post('refresh', 'refresh')->name('refresh');
                Route::get('/', 'indexForIntegration')->name('index');
            });
            Route::prefix('shipments')->name('shipments.')->controller(AmazonNewFbaInboundShipmentController::class)->group(function () {
                Route::post('process', 'process')->name('process');
                Route::post('process-all', 'processAll')->name('process-all');
                Route::post('unprocess', 'unprocess')->name('unprocess');
                Route::post('set-sent-before-initial-count', 'setSentBeforeInitialCount')->name('set-sent-before-initial-count');
                Route::get('unlinked', 'getUnlinkedShipments')->name('get-unlinked');
                Route::get('/', 'indexForIntegration')->name('index');
            });
        });
        Route::apiResource('new-inbound/shipments', AmazonNewFbaInboundShipmentController::class)->only('show');

        Route::prefix('outbound')->name('outbound.')->controller(AmazonOutboundFulfillmentController::class)->group(function () {
            Route::post('refresh', 'refresh')->name('refresh');
        });

        Route::prefix('removal-orders')->name('removal-orders.')->controller(AmazonFbaRemovalOrderController::class)->group(function () {
            Route::get('unlinked', 'getUnlinked');
            Route::get('export', 'exportForIntegration')->name('export');
            Route::post('process', 'process')->name('process');
            Route::post('process-all', 'processAll')->name('process-all');
            Route::post('unprocess', 'unprocess')->name('unprocess');
            Route::post('/{removalOrder}/mark-item-as-unknown', 'markItemAsUnknown')->name('mark-item-as-unknown');
            Route::post('/{removalOrder}/unmark-item-as-unknown', 'unmarkItemAsUnknown')->name('unmark-item-as-unknown');
            Route::get('/', 'indexForIntegration')->name('index');
        });
        Route::apiResource('removal-orders', AmazonFbaRemovalOrderController::class)->only('show');

        Route::prefix('/finances')->name('finances.')->group(function () {
            Route::post('/event-groups/create-accounting-transactions', [AmazonFinancialEventGroupController::class, 'createAccountingTransactions'])
                ->name('finances.event-groups.create-accounting-transactions');
            Route::apiResource('/event-groups', AmazonFinancialEventGroupController::class)
                ->only('show');
            Route::get('/event-groups', [AmazonFinancialEventGroupController::class, 'indexForIntegration']);

            Route::get('/settlement-data/type-mappings', [AmazonReportSettlementDataController::class, 'getTypeMappings']);
            Route::put('/settlement-data/type-mappings', [AmazonReportSettlementDataController::class, 'mapSettlementTypes']);
            Route::post('/settlement-data/type-mappings/import', [AmazonReportSettlementDataController::class, 'importSettlementTypes']);
            Route::apiResource('/settlement-data', AmazonReportSettlementDataController::class)
                ->only('show');
            Route::get('/settlement-data', [AmazonReportSettlementDataController::class, 'indexForIntegration']);

            Route::get('/shipment-events', [AmazonFinancialShipmentEventController::class, 'indexForIntegration']);

            Route::get('nominal-code-mappings', [AmazonFinancialEventTypeNominalCodeMappingController::class, 'indexForIntegration']);
            Route::apiResource('nominal-code-mappings', AmazonFinancialEventTypeNominalCodeMappingController::class)->only('store', 'index');
        });

        Route::prefix('restock-report')->name('restock-report.')->controller(AmazonFbaReportRestockController::class)->group(function () {
            Route::get('/', 'indexForIntegration')->name('index');
            Route::get('export', 'exportForIntegration')->name('export');
        });
        Route::apiResource('restock-report', AmazonFbaReportRestockController::class)->only('show');

        Route::get('lpn-lookup', AmazonFbaLpnLookupController::class)->name('lpn-lookup');
    });
});

Route::get('/amazon/{integrationInstance}/finances/settlement-data/type-mappings/export', [AmazonReportSettlementDataController::class, 'exportSettlementTypes']);
