<?php

namespace Modules\Amazon\Repositories;

use App\Abstractions\AbstractRepository;
use Illuminate\Database\Eloquent\Collection as EloquentCollection;
use Modules\Amazon\Entities\AmazonFbaReportRemovalOrder;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

class AmazonRemovalOrderRepository extends AbstractRepository
{
    public function getRemovalOrdersFromOrderId(string $orderId): EloquentCollection
    {
        return AmazonFbaReportRemovalOrder::whereOrderId($orderId)->get();
    }

    public function saveErrorForRemovalOrderId(string $orderId, string $error): void {
        AmazonFbaReportRemovalOrder::whereOrderId($orderId)->update([
            'errorLog' => $error
        ]);
    }

    public function getUnprocessed(AmazonIntegrationInstance $integrationInstance): EloquentCollection
    {
        return AmazonFbaReportRemovalOrder::query()
            ->where('integration_instance_id', $integrationInstance->id)
            ->whereNull('sku_link_id')
            ->get();
    }
}