<?php

namespace Modules\Amazon\Repositories;

use App\Models\NominalCode;
use Modules\Amazon\Entities\AmazonFinancialEventTypeNominalCodeMapping;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

class AmazonFinancialEventTypeNominalCodeMappingRepository
{
    public function getAllNominalCodeMappings(AmazonIntegrationInstance $integrationInstance)
    {
        return AmazonFinancialEventTypeNominalCodeMapping::where('integration_instance_id', $integrationInstance->id)->with('nominalCode')->get();
    }

    public function getAllNominalCodeMappingById(AmazonIntegrationInstance $integrationInstance, int $id): AmazonFinancialEventTypeNominalCodeMapping
    {
        return AmazonFinancialEventTypeNominalCodeMapping::where('integration_instance_id', $integrationInstance->id)->findOrFail($id);
    }

    public function firstOrCreate(AmazonIntegrationInstance $integrationInstance, string $name): AmazonFinancialEventTypeNominalCodeMapping
    {
        $nominalCodeMapping = AmazonFinancialEventTypeNominalCodeMapping::firstOrCreate([
            'integration_instance_id' => $integrationInstance->id,
            'name' => $name,
        ]);

        $nominalCodeMapping->load('nominalCode');

        return $nominalCodeMapping;
    }

    public function mapNominalCode(AmazonFinancialEventTypeNominalCodeMapping $nominalCodeMapping, NominalCode $nominalCode): AmazonFinancialEventTypeNominalCodeMapping
    {
        $nominalCodeMapping->nominal_code_id = $nominalCode->id;
        $nominalCodeMapping->update();

        return $nominalCodeMapping;
    }
}
