<?php

namespace Modules\Amazon\Repositories;

use Modules\Amazon\Data\AmazonFbaInboundPlanItemData;
use Modules\Amazon\Entities\AmazonNewFbaInboundPlanItem;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\DataCollection;

class AmazonFbaInboundPlanItemRepository
{
    protected AmazonNewFbaInboundPlanRepository $plans;

    public function __construct()
    {
        $this->plans = app(AmazonNewFbaInboundPlanRepository::class);
    }

    public function save(
        int $planId,
        #[DataCollectionOf(AmazonFbaInboundPlanItemData::class)] DataCollection $data
    ): void
    {
        $data = $data->toCollection();
        $upsertData = $data->map(function (AmazonFbaInboundPlanItemData $item) use ($planId) {
            return [
                'amazon_new_fba_inbound_plan_id' => $planId,
                'json_object' => json_encode($item->json_object),
            ];
        })->toArray();

        AmazonNewFbaInboundPlanItem::upsert($upsertData, ['amazon_new_fba_inbound_plan_id', 'msku']);
    }
}
