<?php

namespace Modules\Amazon\Providers;

use App\Models\InventoryAdjustment;
use App\Models\PurchaseOrderShipmentReceiptLine;
use App\Models\SalesCreditReturnLine;
use App\Models\SalesOrderFulfillmentLine;
use App\Models\WarehouseTransferLine;
use App\Models\WarehouseTransferShipmentLine;
use App\Models\WarehouseTransferShipmentReceiptLine;
use Illuminate\Support\ServiceProvider;
use Modules\Amazon\Observers\AmazonAdjustmentObserver;
use Modules\Amazon\Observers\AmazonPurchaseOrderShipmentReceiptLineObserver;
use Modules\Amazon\Observers\AmazonSalesCreditReturnLineObserver;
use Modules\Amazon\Observers\AmazonSalesOrderFulfillmentLineObserver;
use Modules\Amazon\Observers\AmazonWarehouseTransferLineObserver;
use Modules\Amazon\Observers\AmazonWarehouseTransferShipmentLineObserver;
use Modules\Amazon\Observers\AmazonWarehouseTransferShipmentReceiptLineObserver;

class EventServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        WarehouseTransferLine::observe(AmazonWarehouseTransferLineObserver::class);
        WarehouseTransferShipmentLine::observe(AmazonWarehouseTransferShipmentLineObserver::class);
        WarehouseTransferShipmentReceiptLine::observe(AmazonWarehouseTransferShipmentReceiptLineObserver::class);
        PurchaseOrderShipmentReceiptLine::observe(AmazonPurchaseOrderShipmentReceiptLineObserver::class);
        SalesOrderFulfillmentLine::observe(AmazonSalesOrderFulfillmentLineObserver::class);
        SalesCreditReturnLine::observe(AmazonSalesCreditReturnLineObserver::class);
        InventoryAdjustment::observe(AmazonAdjustmentObserver::class);
    }
}
