<?php

namespace Modules\Amazon\Providers;

use App\Providers\ModuleServiceProvider;

class AmazonServiceProvider extends ModuleServiceProvider
{

    /**
     * Boot the application events.
     */
    public function boot(): void
    {
        parent::boot();
        $this->registerCommands('\Modules\Amazon\Console');
    }

    /**
     * Register the service provider.
     */
    public function register(): void
    {
        parent::register();
        $this->app->register(AmazonJobProvider::class);
        $this->app->register(EventServiceProvider::class);
        $this->app->register(RouteServiceProvider::class);

        //$this->app->bind(AmazonIntegrationInstance::class, AmazonClient::class);
        //$this->app->bind(AmazonClient::class, AmazonIntegrationInstance::class);
        //$this->app->bind(IntegrationClientInterface::class, AmazonClient::class);
        //$this->app->bind(IntegrationInstanceInterface::class, AmazonClient::class);
        //        $this->app->when(AmazonIntegrationInstance::class)
        //            ->needs(IntegrationClientInterface::class)
        //            ->give(AmazonClient::class);
    }


    protected function moduleName(): string
    {
        return 'Amazon';
    }

    protected function moduleNameLower(): string
    {
        return 'amazon';
    }
}
