<?php

namespace Modules\Amazon\Providers;

use Artisan;
use Illuminate\Queue\Events\JobProcessed;
use Illuminate\Support\Facades\Queue;
use Illuminate\Support\ServiceProvider;
use Modules\Amazon\Jobs\RefreshAmazonOrderItemsJob;

class AmazonJobProvider extends ServiceProvider
{
    private JobProcessed $jobEvent;

    private $jobData;

    private function isRepeatableJob()
    {
        foreach ([
            RefreshAmazonOrderItemsJob::class,
        ] as $jobName) {
            if ($this->jobEvent->job->resolveName() === $jobName) {
                return true;
            }
        }
    }

    private function repeatJob()
    {
        switch ($this->jobEvent->job->resolveName()) {
            case RefreshAmazonOrderItemsJob::class:
                Artisan::call('amazon:orders:refresh-items '.$this->jobData->amazonIntegrationInstance->id);
                break;
        }
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        Queue::after(function (JobProcessed $event) {
            $this->jobEvent = $event;

            if ($this->isRepeatableJob($event) && @is_null($this->jobEvent->job->payload()['data']['command'])) {
                $this->jobData = unserialize($this->jobEvent->job->payload()['data']['command']);
                $this->repeatJob($event);
            }
        });
    }

    /**
     * Get the services provided by the provider.
     */
    public function provides(): array
    {
        return [];
    }
}
