<?php

namespace Modules\Amazon\Observers;

use App\Models\Warehouse;
use App\Models\WarehouseTransferShipmentLine;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Repositories\AmazonLedgerRepository;

class AmazonWarehouseTransferShipmentLineObserver
{
    private AmazonLedgerRepository $ledgers;

    public function __construct()
    {
        $this->ledgers = app(AmazonLedgerRepository::class);
    }

    public function deleted(WarehouseTransferShipmentLine $warehouseTransferShipmentLine)
    {
        $this->ledgers->clearSkuLinkForSkuModel(new AmazonFbaReportInventoryLedger, $warehouseTransferShipmentLine);
        $warehouseTransfer = $warehouseTransferShipmentLine->warehouseTransferLine->warehouseTransfer;

        $fromWarehouse = $warehouseTransfer->fromWarehouse;
        $toWarehouse = $warehouseTransfer->toWarehouse;

        if ($fromWarehouse->type == Warehouse::TYPE_AMAZON_FBA && $toWarehouse->type == Warehouse::TYPE_AMAZON_FBA) {
            $warehouseTransferShipmentLines = $warehouseTransferShipmentLine->warehouseTransferShipment->shipmentLines;
            if ($warehouseTransferShipmentLines->count() == 0) {
                $warehouseTransferShipmentLine->warehouseTransferShipment->delete();
                $warehouseTransferShipments = $warehouseTransferShipmentLine->warehouseTransferShipment->warehouseTransfer->shipments;
                if ($warehouseTransferShipments->count() == 0) {
                    $warehouseTransferShipmentLine->warehouseTransferShipment->warehouseTransfer->delete();
                }
            }
        }
    }
}
