<?php

namespace Modules\Amazon\Observers;

use App\Models\InventoryAdjustment;
use App\Models\Warehouse;
use Modules\Amazon\Entities\AmazonFbaReportInventoryLedger;
use Modules\Amazon\Repositories\AmazonLedgerRepository;

class AmazonAdjustmentObserver
{
    private AmazonLedgerRepository $ledgers;

    public function __construct()
    {
        $this->ledgers = app(AmazonLedgerRepository::class);
    }

    public function deleted(InventoryAdjustment $inventoryAdjustment): void
    {
        if ($inventoryAdjustment->warehouse->type == Warehouse::TYPE_AMAZON_FBA) {
            $inventoryAdjustment->amazonTransferReceiptGroupLine?->delete();
            $this->ledgers->clearSkuLinkForSkuModel(new AmazonFbaReportInventoryLedger, $inventoryAdjustment);
        }
    }
}
