<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Bus\Batchable;
use Illuminate\Support\Collection;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonProductManager;

class SearchAmazonCatalogItemsJob extends AmazonJob
{
    use Batchable;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(
        protected AmazonIntegrationInstance $amazonIntegrationInstance,
        protected Collection $amazonProducts
    ) {
        $this->onQueue('sales-channels');
    }

    /**
     * Get the tags that should be assigned to the job.
     */
    public function tags(): array
    {
        return ['SearchAmazonCatalogItemsJob'];
    }

    /**
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        (new AmazonProductManager($this->amazonIntegrationInstance))->searchCatalogItems($this->amazonProducts);

        //This is added just to complete the flow
        return AmazonResponseData::from([
            'nextToken' => null,
            'collection' => collect(),
        ]);
    }
}
