<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonOrderManager;

class RefreshAmazonOrderItemsJob extends AmazonJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 10;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(public AmazonIntegrationInstance $amazonIntegrationInstance, protected array $orderIds)
    {
        $this->uniqueId = get_class($this).':'.$this->amazonIntegrationInstance->id;
    }

    /**
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        customlog('amazon', 'Refreshing order items', [
            'integration_instance_id' => $this->amazonIntegrationInstance->id,
            'order_ids' => $this->orderIds,
        ]);
        (new AmazonOrderManager($this->amazonIntegrationInstance))->refreshOrderItems($this->orderIds);

        return AmazonResponseData::from([
            'nextToken' => null,
            'collection' => collect(),
        ]);
    }
}
