<?php

namespace Modules\Amazon\Jobs;

use Carbon\Carbon;
use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonFinanceManager;

class RefreshAmazonFinancialEventGroupsJob extends AmazonJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 10;

    public function __construct(
        protected AmazonIntegrationInstance $amazonIntegrationInstance,
        protected ?Carbon $startedAfter = null
    ) {
        $this->uniqueId = get_class($this).':'.$this->amazonIntegrationInstance->id;
    }

    /**
     * Get amazon orders.
     *
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        return (new AmazonFinanceManager($this->amazonIntegrationInstance))
            ->refreshFinancialEventGroups($this->startedAfter, @$this->jobPayload['nextToken']);
    }
}
