<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonFeedManager;
use Modules\Amazon\Repositories\AmazonFeedRepository;
use Throwable;

class RefreshAmazonFeedSubmissionJob extends AmazonJob
{
    protected AmazonFeedRepository $feedRepository;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected string $feedId)
    {
        $this->feedRepository = app(AmazonFeedRepository::class);
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function apiCall(): AmazonResponseData
    {
        $amazonFeedSubmission = $this->feedRepository->getFromFeedId($this->feedId);

        if ($amazonFeedSubmission) {
            if (is_null($amazonFeedSubmission->resultFeedDocumentId)) {
                (new AmazonFeedManager($amazonFeedSubmission->integrationInstance))->getAmazonFeedDetails($amazonFeedSubmission);
            }

            if (is_null($amazonFeedSubmission->url) && ! is_null($amazonFeedSubmission->resultFeedDocumentId)) {
                (new AmazonFeedManager($amazonFeedSubmission->integrationInstance))->getAmazonFeedResultDocument($amazonFeedSubmission);
            }
        }

        return AmazonResponseData::from([
            'collection' => [],
        ]);
    }
}
