<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonInboundManager;

class RefreshAmazonFbaInboundShipmentsJob extends AmazonJob implements ShouldBeUnique
{
    public string $uniqueId;

    public int $uniqueFor = 60 * 5;

    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance, protected ?string $lastUpdatedAfter = null)
    {
        $this->uniqueId = get_class($this).':'.$this->amazonIntegrationInstance->id;
    }

    /**
     * Get amazon orders.
     *
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        return (new AmazonInboundManager($this->amazonIntegrationInstance))->refreshShipments($this->lastUpdatedAfter, @$this->jobPayload['nextToken']);
    }
}
