<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetInboundPlansAdt;
use Modules\Amazon\Data\AmazonResponseData;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Enums\Entities\FbaInboundPlanStatusEnum;
use Modules\Amazon\Jobs\Abstractions\AmazonJob;
use Modules\Amazon\Managers\AmazonNewInboundManager;

class RefreshAmazonFbaInboundPlansJob extends AmazonJob
{
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
    }

    /**
     * Get amazon orders.
     *
     * @throws Exception
     */
    public function apiCall(): AmazonResponseData
    {
        /*
             * TODO: Open case with Amazon about no limit issue.... in the meantime can handle by using combination of sortBy, sortOrder
             *  and checking lastUpdatedAt in database vs response minimum to see if next page of results is needed or not
             *  consider that once saved to the database... the results will differ so the comparison may need to be done before saving
             */
        return (new AmazonNewInboundManager($this->amazonIntegrationInstance))->refreshPlans((new AmazonGetInboundPlansAdt(
            status: FbaInboundPlanStatusEnum::SHIPPED,
            paginationToken: @$this->jobPayload['nextToken'],
        )));
    }
}
