<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Modules\Amazon\Entities\AmazonReport;
use Modules\Amazon\Managers\AmazonReportManager;
use Throwable;

class ProcessAmazonReportsJob extends AmazonBaseJob
{
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected AmazonReport $amazonReport)
    {
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        (new AmazonReportManager($this->amazonReport->integrationInstance))->process($this->amazonReport);
    }
}
