<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Contracts\Broadcasting\ShouldBeUnique;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;
use Modules\Amazon\Managers\AmazonLedgerManager;
use Throwable;

class LinkLedgersToDetailReportsJob extends AmazonBaseJob implements ShouldBeUnique
{
    protected ?AmazonReport $amazonReport;

    public function uniqueId(): string
    {
        return $this->amazonIntegrationInstance->id;
    }

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        (new AmazonLedgerManager($this->amazonIntegrationInstance))->linkAllLedgersToDetailReports();
    }
}
