<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonOrderManager;

class GetAmazonOrderJob implements ShouldBeUnique
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public string $uniqueId;

    public int $uniqueFor = 60 * 5;

    public function __construct(
        protected AmazonIntegrationInstance $amazonIntegrationInstance,
        protected string $amazonOrderId,
    ) {
        $this->uniqueId = get_class($this).':'.$this->amazonIntegrationInstance->id.':'.$this->amazonOrderId;
    }

    /**
     * @throws Exception
     */
    public function handle(): void
    {
        (new AmazonOrderManager($this->amazonIntegrationInstance))->getOrder($this->amazonOrderId);
    }
}
