<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonOrderManager;
use Throwable;

class FulfillAmazonMfnOrdersJob implements ShouldBeUnique, ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $timeout = 60;

    protected int $uniqueFor = 60;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(public AmazonIntegrationInstance $amazonIntegrationInstance)
    {
    }

    public function uniqueId(): string
    {
        return get_class($this).'-'.$this->amazonIntegrationInstance->id;
    }

    public function tags(): array
    {
        return [
            get_class($this),
        ];
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        (new AmazonOrderManager($this->amazonIntegrationInstance))->fulfillPendingAmazonMfnOrders();
    }
}
