<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonProductManager;
use Throwable;

/*
 * TODO: Should this be a unique job?
 */
class CreateSkuProductsFromAmazonJob extends AmazonBaseJob // implements ShouldBeUnique
{
    //public int $uniqueFor = 600;

    /**
     * @return string
     */
    /*public function uniqueId(): string
    {
        return 'create-sku-products-'.$this->amazonIntegrationInstance->id;
    }*/
    /**
     * Create a new job instance.
     *
     * @return void
     *
     * @throws Exception
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        (new AmazonProductManager($this->amazonIntegrationInstance))->createSkuProducts([], true);
    }
}
