<?php

namespace Modules\Amazon\Jobs;

use Exception;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Managers\AmazonOrderManager;
use Throwable;

class CreateSkuOrdersJob implements ShouldQueue
{
    use Batchable, Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(public AmazonIntegrationInstance $amazonIntegrationInstance, public array $ids = [])
    {
        $this->onQueue('salesOrderProcessing');
    }

    public function tags(): array
    {
        return [
            get_class($this),
        ];
    }

    /**
     * Execute the job.
     *
     * @throws Exception
     * @throws Throwable
     */
    public function handle(): void
    {
        customlog('salesOrderProcessing', 'CreateSkuOrdersJob for '.count($this->ids).' orders');
        (new AmazonOrderManager($this->amazonIntegrationInstance))->createSkuOrders($this->ids, empty($this->ids));
    }
}
