<?php

namespace Modules\Amazon\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Repositories\AmazonOrderRepository;
use Throwable;

class CreateAmazonRefreshOrderItemsJobs implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected AmazonOrderRepository $amazonOrderRepository;

    /**
     * Create a new job instance
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
        $this->amazonOrderRepository = app(AmazonOrderRepository::class);
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        $orderIds = $this->amazonOrderRepository->getActiveItemlessOrderIds();

        if ($orderIds->count() > 0) {
            RefreshAmazonOrderItemsJob::dispatch($this->amazonIntegrationInstance, $orderIds->toArray());
        }
    }
}
