<?php

namespace Modules\Amazon\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetInboundShipmentItemsAdt;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Repositories\AmazonNewFbaInboundShipmentRepository;
use Throwable;

class CreateAmazonRefreshNewFbaInboundShipmentItemsJobs implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private AmazonNewFbaInboundShipmentRepository $amazonFbaInboundShipmentRepository;

    /**
     * Create a new job instance
     *
     * @return void
     */
    public function __construct(protected AmazonIntegrationInstance $amazonIntegrationInstance)
    {
        $this->amazonFbaInboundShipmentRepository = app(AmazonNewFbaInboundShipmentRepository::class);
    }

    /**
     * Execute the job.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        $shipmentIds = $this->amazonFbaInboundShipmentRepository->getActiveItemlessShipmentIds();

        $shipmentIds->each(function (string $shipmentId) {
            $shipment = $this->amazonFbaInboundShipmentRepository->getFromShipmentId($this->amazonIntegrationInstance, $shipmentId);

            RefreshAmazonNewFbaInboundShipmentItemsJob::dispatch($this->amazonIntegrationInstance, new AmazonGetInboundShipmentItemsAdt(
                planId: $shipment->amazonFbaInboundPlan->inboundPlanId,
                shipmentId: $shipmentId,
            ));
        });
    }
}
